using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using DarkStride.StellarLanes.SharedDLL;


namespace ShipBuilder
{
	public class frmModuleType : System.Windows.Forms.Form
	{
		#region Properties
		private int m_nModuleTypesAllowed = 0;
		#endregion

		#region System Stuff
		private System.Windows.Forms.Button cmdOk;
		private System.Windows.Forms.Button cmdCancel;
		private System.Windows.Forms.CheckBox chkdEngine;
		private System.Windows.Forms.RadioButton rdoCantBeUsed;
		private System.Windows.Forms.RadioButton rdoOuterSpace;
		private System.Windows.Forms.RadioButton rdoAllowsModules;
		private System.Windows.Forms.CheckBox chkConnector;
		private System.Windows.Forms.CheckBox chkPowerGen;
		private System.Windows.Forms.CheckBox chkShields;
		private System.Windows.Forms.CheckBox chkHanger;
		private System.Windows.Forms.CheckBox chkWeapons;
		private System.Windows.Forms.CheckBox chkHUD;
		private System.Windows.Forms.CheckBox chkOther;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public frmModuleType()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.chkdEngine = new System.Windows.Forms.CheckBox();
			this.rdoCantBeUsed = new System.Windows.Forms.RadioButton();
			this.rdoOuterSpace = new System.Windows.Forms.RadioButton();
			this.rdoAllowsModules = new System.Windows.Forms.RadioButton();
			this.chkConnector = new System.Windows.Forms.CheckBox();
			this.chkPowerGen = new System.Windows.Forms.CheckBox();
			this.chkShields = new System.Windows.Forms.CheckBox();
			this.chkHanger = new System.Windows.Forms.CheckBox();
			this.chkWeapons = new System.Windows.Forms.CheckBox();
			this.chkHUD = new System.Windows.Forms.CheckBox();
			this.chkOther = new System.Windows.Forms.CheckBox();
			this.cmdOk = new System.Windows.Forms.Button();
			this.cmdCancel = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// chkdEngine
			// 
			this.chkdEngine.Enabled = false;
			this.chkdEngine.Location = new System.Drawing.Point(56, 104);
			this.chkdEngine.Name = "chkdEngine";
			this.chkdEngine.Size = new System.Drawing.Size(128, 16);
			this.chkdEngine.TabIndex = 0;
			this.chkdEngine.Text = "Engine";
			// 
			// rdoCantBeUsed
			// 
			this.rdoCantBeUsed.Location = new System.Drawing.Point(16, 40);
			this.rdoCantBeUsed.Name = "rdoCantBeUsed";
			this.rdoCantBeUsed.Size = new System.Drawing.Size(176, 32);
			this.rdoCantBeUsed.TabIndex = 1;
			this.rdoCantBeUsed.Text = "Can\'t Be Used (Part of the chassis but no modules)";
			// 
			// rdoOuterSpace
			// 
			this.rdoOuterSpace.Location = new System.Drawing.Point(16, 72);
			this.rdoOuterSpace.Name = "rdoOuterSpace";
			this.rdoOuterSpace.Size = new System.Drawing.Size(112, 16);
			this.rdoOuterSpace.TabIndex = 2;
			this.rdoOuterSpace.Text = "Open Space";
			// 
			// rdoAllowsModules
			// 
			this.rdoAllowsModules.Checked = true;
			this.rdoAllowsModules.Location = new System.Drawing.Point(16, 88);
			this.rdoAllowsModules.Name = "rdoAllowsModules";
			this.rdoAllowsModules.Size = new System.Drawing.Size(112, 16);
			this.rdoAllowsModules.TabIndex = 3;
			this.rdoAllowsModules.TabStop = true;
			this.rdoAllowsModules.Text = "Allows Modules";
			this.rdoAllowsModules.CheckedChanged += new System.EventHandler(this.rdoAllowsModules_CheckedChanged);
			// 
			// chkConnector
			// 
			this.chkConnector.Location = new System.Drawing.Point(16, 8);
			this.chkConnector.Name = "chkConnector";
			this.chkConnector.Size = new System.Drawing.Size(128, 16);
			this.chkConnector.TabIndex = 4;
			this.chkConnector.Text = "Is A Connector";
			// 
			// chkPowerGen
			// 
			this.chkPowerGen.Enabled = false;
			this.chkPowerGen.Location = new System.Drawing.Point(56, 120);
			this.chkPowerGen.Name = "chkPowerGen";
			this.chkPowerGen.Size = new System.Drawing.Size(128, 16);
			this.chkPowerGen.TabIndex = 5;
			this.chkPowerGen.Text = "Power Generation";
			// 
			// chkShields
			// 
			this.chkShields.Enabled = false;
			this.chkShields.Location = new System.Drawing.Point(56, 136);
			this.chkShields.Name = "chkShields";
			this.chkShields.Size = new System.Drawing.Size(128, 16);
			this.chkShields.TabIndex = 6;
			this.chkShields.Text = "Shields";
			// 
			// chkHanger
			// 
			this.chkHanger.Enabled = false;
			this.chkHanger.Location = new System.Drawing.Point(56, 152);
			this.chkHanger.Name = "chkHanger";
			this.chkHanger.Size = new System.Drawing.Size(128, 16);
			this.chkHanger.TabIndex = 7;
			this.chkHanger.Text = "Hanger";
			// 
			// chkWeapons
			// 
			this.chkWeapons.Enabled = false;
			this.chkWeapons.Location = new System.Drawing.Point(56, 168);
			this.chkWeapons.Name = "chkWeapons";
			this.chkWeapons.Size = new System.Drawing.Size(128, 16);
			this.chkWeapons.TabIndex = 8;
			this.chkWeapons.Text = "Weapon";
			// 
			// chkHUD
			// 
			this.chkHUD.Enabled = false;
			this.chkHUD.Location = new System.Drawing.Point(56, 184);
			this.chkHUD.Name = "chkHUD";
			this.chkHUD.Size = new System.Drawing.Size(128, 16);
			this.chkHUD.TabIndex = 9;
			this.chkHUD.Text = "H.U.D.";
			// 
			// chkOther
			// 
			this.chkOther.Enabled = false;
			this.chkOther.Location = new System.Drawing.Point(56, 208);
			this.chkOther.Name = "chkOther";
			this.chkOther.Size = new System.Drawing.Size(128, 16);
			this.chkOther.TabIndex = 10;
			this.chkOther.Text = "Other";
			// 
			// cmdOk
			// 
			this.cmdOk.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdOk.Location = new System.Drawing.Point(136, 240);
			this.cmdOk.Name = "cmdOk";
			this.cmdOk.Size = new System.Drawing.Size(80, 24);
			this.cmdOk.TabIndex = 11;
			this.cmdOk.Text = "Ok";
			this.cmdOk.Click += new System.EventHandler(this.cmdOk_Click);
			// 
			// cmdCancel
			// 
			this.cmdCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.cmdCancel.Location = new System.Drawing.Point(8, 240);
			this.cmdCancel.Name = "cmdCancel";
			this.cmdCancel.Size = new System.Drawing.Size(80, 24);
			this.cmdCancel.TabIndex = 12;
			this.cmdCancel.Text = "Cancel";
			this.cmdCancel.Click += new System.EventHandler(this.cmdCancel_Click);
			// 
			// frmModuleType
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(224, 269);
			this.ControlBox = false;
			this.Controls.Add(this.cmdCancel);
			this.Controls.Add(this.cmdOk);
			this.Controls.Add(this.chkOther);
			this.Controls.Add(this.chkHUD);
			this.Controls.Add(this.chkWeapons);
			this.Controls.Add(this.chkHanger);
			this.Controls.Add(this.chkShields);
			this.Controls.Add(this.chkPowerGen);
			this.Controls.Add(this.chkConnector);
			this.Controls.Add(this.rdoAllowsModules);
			this.Controls.Add(this.rdoOuterSpace);
			this.Controls.Add(this.rdoCantBeUsed);
			this.Controls.Add(this.chkdEngine);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.Name = "frmModuleType";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Module Types";
			this.Load += new System.EventHandler(this.frmModuleType_Load);
			this.ResumeLayout(false);

		}
		#endregion
		#endregion


		private void frmModuleType_Load(object sender, System.EventArgs e)
		{
			chkConnector.Checked= ( ( m_nModuleTypesAllowed & (int)enumModuleType.Connector ) == (int)enumModuleType.Connector );
			chkdEngine.Checked	= ( ( m_nModuleTypesAllowed & (int)enumModuleType.Engine ) == (int)enumModuleType.Engine );
			chkHanger.Checked 	= ( ( m_nModuleTypesAllowed & (int)enumModuleType.Hanger ) == (int)enumModuleType.Hanger );
			chkHUD.Checked 		= ( ( m_nModuleTypesAllowed & (int)enumModuleType.HUD ) == (int)enumModuleType.HUD );
			chkOther.Checked 	= ( ( m_nModuleTypesAllowed & (int)enumModuleType.Other ) == (int)enumModuleType.Other );
			chkPowerGen.Checked = ( ( m_nModuleTypesAllowed & (int)enumModuleType.PowerGen ) == (int)enumModuleType.PowerGen );
			chkShields.Checked 	= ( ( m_nModuleTypesAllowed & (int)enumModuleType.ShieldGen ) == (int)enumModuleType.ShieldGen );
			chkWeapons.Checked 	= ( ( m_nModuleTypesAllowed & (int)enumModuleType.Weapon ) == (int)enumModuleType.Weapon );

			if( ( m_nModuleTypesAllowed & (int)enumModuleType.CantBeUsed ) == (int)enumModuleType.CantBeUsed )
			{
				rdoCantBeUsed.Checked = true;
			}
			else if( ( m_nModuleTypesAllowed & (int)enumModuleType.OpenSpace ) == (int)enumModuleType.OpenSpace )
			{
				rdoOuterSpace.Checked = true;
			}
			else
			{
				rdoAllowsModules.Checked = true;
			}

			rdoAllowsModules_CheckedChanged( null,null );
		}

		private void cmdOk_Click(object sender, System.EventArgs e)
		{
			int nNewTypesAllowed = 0;

			if( chkConnector.Checked == true )
			{
				nNewTypesAllowed = ( nNewTypesAllowed | (int)enumModuleType.Connector );
			}
			if( rdoOuterSpace.Checked == true )
			{
				nNewTypesAllowed = ( nNewTypesAllowed | (int)enumModuleType.OpenSpace );
			}
			if( rdoCantBeUsed.Checked == true )
			{
				nNewTypesAllowed = ( nNewTypesAllowed | (int)enumModuleType.CantBeUsed );
			}			
			if( chkdEngine.Checked == true && rdoAllowsModules.Checked == true )
			{
				nNewTypesAllowed = ( nNewTypesAllowed | (int)enumModuleType.Engine );
			}
			if( chkHanger.Checked == true && rdoAllowsModules.Checked == true )
			{
				nNewTypesAllowed = ( nNewTypesAllowed | (int)enumModuleType.Hanger );
			}
			if( chkHUD.Checked == true && rdoAllowsModules.Checked == true )
			{
				nNewTypesAllowed = ( nNewTypesAllowed | (int)enumModuleType.HUD );
			}
			if( chkOther.Checked == true && rdoAllowsModules.Checked == true )
			{
				nNewTypesAllowed = ( nNewTypesAllowed | (int)enumModuleType.Other );
			}
			if( chkPowerGen.Checked == true && rdoAllowsModules.Checked == true )
			{
				nNewTypesAllowed = ( nNewTypesAllowed | (int)enumModuleType.PowerGen );
			}
			if( chkShields.Checked == true && rdoAllowsModules.Checked == true )
			{
				nNewTypesAllowed = ( nNewTypesAllowed | (int)enumModuleType.ShieldGen );
			}
			if( chkWeapons.Checked == true && rdoAllowsModules.Checked == true )
			{
				nNewTypesAllowed = ( nNewTypesAllowed | (int)enumModuleType.Weapon );
			}

			m_nModuleTypesAllowed = nNewTypesAllowed;
			this.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.Close();
		}

		private void cmdCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.Close();
		}
		

		private void rdoAllowsModules_CheckedChanged(object sender, System.EventArgs e)
		{
			chkdEngine.Enabled	= ( rdoAllowsModules.Checked == true );
			chkHanger.Enabled	= ( rdoAllowsModules.Checked == true );
			chkHUD.Enabled		= ( rdoAllowsModules.Checked == true );
			chkOther.Enabled	= ( rdoAllowsModules.Checked == true );
			chkPowerGen.Enabled = ( rdoAllowsModules.Checked == true );
			chkShields.Enabled	= ( rdoAllowsModules.Checked == true );
			chkWeapons.Enabled	= ( rdoAllowsModules.Checked == true );
		}



		#region Properties
		public int ModuleTypesAllowed
		{
			get
			{
				return( m_nModuleTypesAllowed );
			}
			set
			{
				m_nModuleTypesAllowed = value;
			}
		}
		#endregion
	}
}
